/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.Controller;
import controlP5.ControllerPlug;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBroadcaster {
    private int _myControlEventType = -1;
    private ControllerPlug _myControlEventPlug = null;
    private ControlP5 _myControlP5;
    private String _myEventMethod = "controlEvent";
    private ArrayList<ControlListener> _myControlListeners;

    protected ControlBroadcaster(ControlP5 controlP5) {
        this._myControlP5 = controlP5;
        this._myControlListeners = new ArrayList();
        this._myControlEventPlug = ControlBroadcaster.checkObject(ControlP5.papplet, this.getEventMethod(), new Class[]{ControlEvent.class});
        if (this._myControlEventPlug != null) {
            this._myControlEventType = 0;
        }
    }

    public void addListener(ControlListener controlListener) {
        this._myControlListeners.add(controlListener);
    }

    public void removeListener(ControlListener controlListener) {
        this._myControlListeners.remove(controlListener);
    }

    public ControlListener getListener(int n) {
        if (n < 0 || n >= this._myControlListeners.size()) {
            return null;
        }
        return this._myControlListeners.get(n);
    }

    public int listenerSize() {
        return this._myControlListeners.size();
    }

    @Deprecated
    public void plug(String string, String string2) {
        this.plug((Object)ControlP5.papplet, string, string2);
    }

    public void plug(Object object, String string, String string2) {
        this.plug(object, this._myControlP5.controller(string), string2);
    }

    public void plug(Object object, Controller controller, String string) {
        if (controller != null) {
            ControllerPlug controllerPlug = ControlBroadcaster.checkObject(object, string, ControlP5Constants.acceptClassList);
            if (controllerPlug == null) {
                return;
            }
            if (!controller.checkControllerPlug(controllerPlug)) {
                controller.addControllerPlug(controllerPlug);
            }
            return;
        }
    }

    protected static ControllerPlug checkObject(Object object, String string, Class<?>[] classArray) {
        int n;
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            if (methodArray[i].getParameterTypes().length == 1) {
                if (methodArray[i].getParameterTypes()[0] == ControlP5Constants.controlEventClass) {
                    return new ControllerPlug(object, string, 2, -1, null);
                }
                for (n = 0; n < classArray.length; ++n) {
                    if (methodArray[i].getParameterTypes()[0] != classArray[n]) continue;
                    return new ControllerPlug(object, string, 0, n, classArray);
                }
                break;
            }
            if (methodArray[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(object, string, 0, -1, classArray);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            if (!fieldArray[n].getName().equals(string)) continue;
            for (int i = 0; i < classArray.length; ++i) {
                if (fieldArray[n].getType() != classArray[i]) continue;
                return new ControllerPlug(object, string, 1, i, classArray);
            }
            break;
        }
        return null;
    }

    public void broadcast(ControlEvent controlEvent, int n) {
        for (ControlListener object : this._myControlListeners) {
            object.controlEvent(controlEvent);
        }
        if (!controlEvent.isTab() && !controlEvent.isGroup() && controlEvent.controller().getControllerPlugList().size() > 0) {
            if (n == 3) {
                for (ControllerPlug controllerPlug : controlEvent.controller().getControllerPlugList()) {
                    this.callTarget(controllerPlug, controlEvent.stringValue());
                }
            } else if (n != 4) {
                for (ControllerPlug controllerPlug : controlEvent.controller().getControllerPlugList()) {
                    if (controllerPlug.checkType(2)) {
                        this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), new Object[]{controlEvent});
                        continue;
                    }
                    this.callTarget(controllerPlug, controlEvent.value());
                }
            }
        }
        if (this._myControlEventType == 0) {
            this.invokeMethod(this._myControlEventPlug.object(), this._myControlEventPlug.getMethod(), new Object[]{controlEvent});
        }
    }

    protected void callTarget(ControllerPlug controllerPlug, float f) {
        if (controllerPlug.checkType(0)) {
            this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), controllerPlug.getMethodParameter(f));
        } else if (controllerPlug.checkType(1)) {
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), controllerPlug.getFieldParameter(f));
        }
    }

    protected void callTarget(ControllerPlug controllerPlug, String string) {
        if (controllerPlug.checkType(0)) {
            this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), new Object[]{string});
        } else if (controllerPlug.checkType(1)) {
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), string);
        }
    }

    private void invokeField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ControlP5.logger().warning(illegalAccessException.toString());
        }
    }

    private void invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            if (objectArray[0] == null) {
                method.invoke(object, new Object[0]);
            } else {
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ControlP5.logger().warning(illegalArgumentException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printMethodError(method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.printMethodError(method, invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            this.printMethodError(method, nullPointerException);
        }
    }

    protected String getEventMethod() {
        return this._myEventMethod;
    }

    private void printMethodError(Method method, Exception exception) {
        ControlP5.logger().severe("An error occured while forwarding a Controller value\n to a method in your program. Please check your code for any \npossible errors that might occur in this method .\n e.g. check for casting errors, possible nullpointers, array overflows ... .\nmethod: " + method.getName() + "\n" + "exception:  " + exception);
    }
}

