/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ListBox;
import controlP5.Numberbox;
import controlP5.Slider;
import controlP5.Textlabel;
import controlP5.Toggle;
import processing.core.PApplet;
import processing.core.PFont;
import processing.serial.Serial;

public class SimpleBGC_GUI_1_3
extends PApplet {
    Serial g_serial;
    ControlP5 controlP5;
    Textlabel txtlblWhichcom;
    ListBox commListbox;
    public static final int COM_SPEED = 115200;
    public static final int FRAMERATE = 20;
    public static int NUM_AXIS = 2;
    public static final int ROLL = 0;
    public static final int PITCH = 1;
    public static final int YAW = 2;
    public static final String[] AXIS_NAME = new String[]{"ROLL", "PITCH", "YAW"};
    public static final int TOGGLE_SIZE = 12;
    public static final int DEBUG_VARS_NUM = 5;
    int commListMax;
    int serialState = 0;
    cGraph g_graph;
    int windowsX = 670;
    int windowsY = 540;
    int xGraph = 10;
    int yGraph = 325;
    int xObj = 550;
    int yObj = 350;
    int xRC = 490;
    int yRC = 10;
    int xParam = 120;
    int yParam = 10;
    int xRange = 120;
    int yRange = 100;
    int xExtGain = 120;
    int yExtGain = 200;
    int xLPF = 320;
    int yLPF = 200;
    public static final int ERR_NO_SENSOR = 1;
    public static final int ERR_CALIB_ACC = 2;
    public static final int ERR_SET_POWER = 4;
    public static final int ERR_CALIB_POLES = 8;
    public static final int ERR_GUI_VERSION = 128;
    private ErrorInfo[] errors = new ErrorInfo[]{new ErrorInfo(1, "Sensor is not connected", "Turn off power and check I2C sensor connection. DON'T CONNECT SENSOR WHEN BOARD IS POWERED!"), new ErrorInfo(2, "Accelerometer is not calibrated", "Simple calibration: Level sensor horisontally as precise as possible, and than press \"CALIB_ACC\". For more precise six-points calibration see instruction manual"), new ErrorInfo(4, "POWER is not set", "Increse POWER from low values (50 for example) until motor will give enough torque, but does not make too hot"), new ErrorInfo(8, "POLES is not set", "Use AUTO calibration to get number of poles and direction. Set precise number of poles manually if detected wrong (it equals to number of magnets in the motor)"), new ErrorInfo(128, "GUI vs board version mismatch", "Try to update GUI to latest version")};
    ErrorInfo error = null;
    boolean axGraph = true;
    boolean ayGraph = true;
    boolean azGraph = true;
    boolean gxGraph = true;
    boolean gyGraph = true;
    boolean gzGraph = true;
    boolean magxGraph = false;
    boolean magyGraph = false;
    boolean magzGraph = false;
    boolean debug1Graph = false;
    boolean debug2Graph = false;
    boolean debug3Graph = false;
    boolean debug4Graph = false;
    cDataArray accPITCH = new cDataArray(100);
    cDataArray accROLL = new cDataArray(100);
    cDataArray accYAW = new cDataArray(100);
    cDataArray gyroPITCH = new cDataArray(100);
    cDataArray gyroROLL = new cDataArray(100);
    cDataArray gyroYAW = new cDataArray(100);
    cDataArray magxData = new cDataArray(100);
    cDataArray magyData = new cDataArray(100);
    cDataArray magzData = new cDataArray(100);
    cDataArray headData = new cDataArray(100);
    cDataArray debug1Data = new cDataArray(100);
    cDataArray debug2Data = new cDataArray(100);
    cDataArray debug3Data = new cDataArray(100);
    cDataArray debug4Data = new cDataArray(100);
    Numberbox[] confP = new Numberbox[3];
    Numberbox[] confI = new Numberbox[3];
    Numberbox[] confD = new Numberbox[3];
    Toggle[] confInv = new Toggle[3];
    Numberbox[] confPower = new Numberbox[3];
    Numberbox[] confPoles = new Numberbox[3];
    Numberbox[] confRcMinAngle = new Numberbox[3];
    Numberbox[] confRcMaxAngle = new Numberbox[3];
    Numberbox[] confRcLPF = new Numberbox[3];
    Toggle[] confRcInc = new Toggle[3];
    Numberbox[] confExtGain = new Numberbox[2];
    Numberbox confGyroLPF;
    Numberbox[] confDebug = new Numberbox[5];
    Button buttonSAVE_DEBUG;
    Slider rcStickRollSlider;
    Slider rcStickPitchSlider;
    Slider rcStickYawSlider;
    Slider extRollSlider;
    Slider extPitchSlider;
    Slider axSlider;
    Slider aySlider;
    Slider azSlider;
    Slider gxSlider;
    Slider gySlider;
    Slider gzSlider;
    Slider magxSlider;
    Slider magySlider;
    Slider magzSlider;
    Slider baroSlider;
    Slider headSlider;
    Slider debug1Slider;
    Slider debug2Slider;
    Slider debug3Slider;
    Slider debug4Slider;
    Slider scaleSlider;
    Button buttonREAD;
    Button buttonWRITE;
    Button buttonCALIBRATE_ACC;
    Button buttonUSE_DEFAULTS;
    Button buttonAUTO_GAIN;
    Button buttonAUTO_POLES;
    int green_ = this.color(30, 120, 30);
    int gray_ = this.color(60, 60, 60);
    int red_ = this.color(255, 0, 0);
    int blue_ = this.color(30, 90, 120);
    boolean graphEnable = false;
    boolean readEnable = false;
    boolean writeEnable = false;
    boolean calibrateEnable = false;
    int version;
    int subversion;
    float head;
    float angx;
    float angy;
    int init_com;
    short cycleCnt = 0;
    int cycleTime;
    int i2cError;
    PFont font8;
    PFont font12;
    PFont font15;
    final int ANG_METER_SCALE = 10;
    PeakMeter peakRoll = new PeakMeter(20);
    PeakMeter peakPitch = new PeakMeter(20);
    AvgFilter avgRoll = new AvgFilter(20.0f);
    AvgFilter avgPitch = new AvgFilter(20.0f);
    int p;
    byte[] inBuf = new byte[512];
    int serialReaded = 0;
    public static final String[] DEBUG_CONTROLS = new String[]{"DEBUG1", "DEBUG2", "DEBUG3", "DEBUG4", "debug1", "debug2", "debug3", "debug4", "debug1Slider", "debug2Slider", "debug3Slider", "debug4Slider", "debugVars", "labelVar0", "labelVar1", "labelVar2", "labelVar3", "labelVar4", "confDebug0", "confDebug1", "confDebug2", "confDebug3", "confDebug4", "SAVE_DEBUG"};
    public boolean showDebug = false;
    public static final String[] YAW_CONTROLS = new String[]{"rcYaw", "rangeLabel2", "confRcMinAngle2", "confRcMaxAngle2", "confRcLPF2", "confRcInc2", "confLabel2", "confP2", "confI2", "confD2", "confPower2", "confInv2", "confPoles2"};

    public ErrorInfo getErrorInfo(int n) {
        if (n > 0) {
            int n2 = 0;
            while (n2 < this.errors.length) {
                if ((this.errors[n2].code & n) > 0) {
                    return this.errors[n2];
                }
                ++n2;
            }
            return new ErrorInfo(0, "UNKNOWN ERROR #" + n, "SEE MANUALS TO CHECK CODE");
        }
        return null;
    }

    public String shortifyPortName(String string, int n) {
        String string2 = string;
        if (string2.startsWith("/dev/")) {
            string2 = string2.substring(5);
        }
        if (string2.startsWith("tty.")) {
            string2 = string2.substring(4);
        }
        if (string.length() > n) {
            string2 = String.valueOf(string2.substring(0, (n - 1) / 2)) + "~" + string2.substring(string2.length() - (n - (n - 1) / 2));
        }
        if (string2.startsWith("cu.")) {
            string2 = "";
        }
        return string2;
    }

    public Controller hideLabel(Controller controller) {
        controller.setLabel("");
        controller.setLabelVisible(false);
        return controller;
    }

    public void setup() {
        this.size(this.windowsX, this.windowsY, "processing.opengl.PGraphicsOpenGL");
        this.frameRate(20.0f);
        this.font8 = this.createFont("Arial bold", 8.0f, false);
        this.font12 = this.createFont("Arial bold", 12.0f, false);
        this.font15 = this.createFont("Arial bold", 15.0f, false);
        this.controlP5 = new ControlP5((PApplet)this);
        this.controlP5.setControlFont(this.font12);
        this.g_graph = new cGraph(this.xGraph + 110, this.yGraph, 480.0f, 200.0f);
        this.commListbox = this.controlP5.addListBox("portComList", 5, 75, 110, 240);
        this.commListbox.captionLabel().set("PORT COM");
        this.commListbox.setColorBackground(this.gray_);
        int n = 0;
        while (n < Serial.list().length) {
            String string = this.shortifyPortName(Serial.list()[n], 13);
            if (string.length() > 0) {
                this.commListbox.addItem(string, n);
            }
            this.commListMax = n++;
        }
        this.commListbox.addItem("Close Comm", ++this.commListMax);
        this.txtlblWhichcom = this.controlP5.addTextlabel("txtlblWhichcom", "No Port Selected", 5, 50);
        n = this.color(0, 0, 0);
        int n2 = this.xGraph - 7;
        int n3 = this.xGraph + 40;
        int n4 = this.yGraph + 10;
        int n5 = this.yGraph + 55;
        int n6 = this.yGraph + 100;
        int n7 = this.yGraph + 145;
        Toggle toggle = this.controlP5.addToggle("ACC_ROLL", true, (float)n3, (float)(n4 + 10), 20, 10);
        toggle.setColorActive(this.color(255, 0, 0));
        toggle.setColorBackground(n);
        toggle.setLabel("");
        toggle.setValue(this.axGraph);
        Toggle toggle2 = this.controlP5.addToggle("ACC_PITCH", true, (float)n3, (float)(n4 + 20), 20, 10);
        toggle2.setColorActive(this.color(0, 255, 0));
        toggle2.setColorBackground(n);
        toggle2.setLabel("");
        toggle2.setValue(this.ayGraph);
        Toggle toggle3 = this.controlP5.addToggle("ACC_Z", true, (float)n3, (float)(n4 + 30), 20, 10);
        toggle3.setColorActive(this.color(0, 0, 255));
        toggle3.setColorBackground(n);
        toggle3.setLabel("");
        toggle3.setValue(this.azGraph);
        Toggle toggle4 = this.controlP5.addToggle("GYRO_ROLL", true, (float)n3, (float)(n5 + 10), 20, 10);
        toggle4.setColorActive(this.color(200, 200, 0));
        toggle4.setColorBackground(n);
        toggle4.setLabel("");
        toggle4.setValue(this.gxGraph);
        Toggle toggle5 = this.controlP5.addToggle("GYRO_PITCH", true, (float)n3, (float)(n5 + 20), 20, 10);
        toggle5.setColorActive(this.color(0, 255, 255));
        toggle5.setColorBackground(n);
        toggle5.setLabel("");
        toggle5.setValue(this.gyGraph);
        Toggle toggle6 = this.controlP5.addToggle("GYRO_YAW", true, (float)n3, (float)(n5 + 30), 20, 10);
        toggle6.setColorActive(this.color(255, 0, 255));
        toggle6.setColorBackground(n);
        toggle6.setLabel("");
        toggle6.setValue(this.gzGraph);
        Toggle toggle7 = this.controlP5.addToggle("MAGX", true, (float)n3, (float)(n6 + 10), 20, 10);
        toggle7.setColorActive(this.color(50, 100, 150));
        toggle7.setColorBackground(n);
        toggle7.setLabel("");
        toggle7.setValue(this.magxGraph);
        Toggle toggle8 = this.controlP5.addToggle("MAGY", true, (float)n3, (float)(n6 + 20), 20, 10);
        toggle8.setColorActive(this.color(100, 50, 150));
        toggle8.setColorBackground(n);
        toggle8.setLabel("");
        toggle8.setValue(this.magyGraph);
        Toggle toggle9 = this.controlP5.addToggle("MAGZ", true, (float)n3, (float)(n6 + 30), 20, 10);
        toggle9.setColorActive(this.color(150, 100, 50));
        toggle9.setColorBackground(n);
        toggle9.setLabel("");
        toggle9.setValue(this.magzGraph);
        Toggle toggle10 = this.controlP5.addToggle("DEBUG1", true, (float)n3, (float)(n7 + 10), 20, 10);
        toggle10.setColorActive(this.color(50, 100, 150));
        toggle10.setColorBackground(n);
        toggle10.setLabel("");
        toggle10.setValue(this.debug1Graph);
        toggle10.hide();
        Toggle toggle11 = this.controlP5.addToggle("DEBUG2", true, (float)n3, (float)(n7 + 20), 20, 10);
        toggle11.setColorActive(this.color(100, 50, 150));
        toggle11.setColorBackground(n);
        toggle11.setLabel("");
        toggle11.setValue(this.debug2Graph);
        Toggle toggle12 = this.controlP5.addToggle("DEBUG3", true, (float)n3, (float)(n7 + 30), 20, 10);
        toggle12.setColorActive(this.color(150, 100, 50));
        toggle12.setColorBackground(n);
        toggle12.setLabel("");
        toggle12.setValue(this.debug3Graph);
        Toggle toggle13 = this.controlP5.addToggle("DEBUG4", true, (float)n3, (float)(n7 + 40), 20, 10);
        toggle13.setColorActive(this.color(150, 150, 0));
        toggle13.setColorBackground(n);
        toggle13.setLabel("");
        toggle13.setValue(this.debug4Graph);
        this.controlP5.addTextlabel("acclabel", "ACC", n2, n4);
        this.controlP5.addTextlabel("accrolllabel", "   ROLL", n2, n4 + 10);
        this.controlP5.addTextlabel("accpitchlabel", "   PITCH", n2, n4 + 20);
        this.controlP5.addTextlabel("acczlabel", "   Z", n2, n4 + 30);
        this.controlP5.addTextlabel("gyrolabel", "GYRO", n2, n5);
        this.controlP5.addTextlabel("gyrorolllabel", "   ROLL", n2, n5 + 10);
        this.controlP5.addTextlabel("gyropitchlabel", "   PITCH", n2, n5 + 20);
        this.controlP5.addTextlabel("gyroyawlabel", "   YAW", n2, n5 + 30);
        this.controlP5.addTextlabel("maglabel", "MAG", n2, n6);
        this.controlP5.addTextlabel("magrolllabel", "   ROLL", n2, n6 + 10);
        this.controlP5.addTextlabel("magpitchlabel", "   PITCH", n2, n6 + 20);
        this.controlP5.addTextlabel("magyawlabel", "   YAW", n2, n6 + 30);
        this.controlP5.addTextlabel("debug1", "debug1", n2, n7 + 10);
        this.controlP5.addTextlabel("debug2", "debug2", n2, n7 + 20);
        this.controlP5.addTextlabel("debug3", "debug3", n2, n7 + 30);
        this.controlP5.addTextlabel("debug4", "debug4", n2, n7 + 40);
        this.axSlider = this.controlP5.addSlider("axSlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 10, 50, 10);
        this.axSlider.setDecimalPrecision(0);
        this.axSlider.setLabel("");
        this.aySlider = this.controlP5.addSlider("aySlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 20, 50, 10);
        this.aySlider.setDecimalPrecision(0);
        this.aySlider.setLabel("");
        this.azSlider = this.controlP5.addSlider("azSlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 30, 50, 10);
        this.azSlider.setDecimalPrecision(0);
        this.azSlider.setLabel("");
        this.gxSlider = this.controlP5.addSlider("gxSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 10, 50, 10);
        this.gxSlider.setDecimalPrecision(0);
        this.gxSlider.setLabel("");
        this.gySlider = this.controlP5.addSlider("gySlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 20, 50, 10);
        this.gySlider.setDecimalPrecision(0);
        this.gySlider.setLabel("");
        this.gzSlider = this.controlP5.addSlider("gzSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 30, 50, 10);
        this.gzSlider.setDecimalPrecision(0);
        this.gzSlider.setLabel("");
        this.magxSlider = this.controlP5.addSlider("magxSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 10, 50, 10);
        this.magxSlider.setDecimalPrecision(0);
        this.magxSlider.setLabel("");
        this.magySlider = this.controlP5.addSlider("magySlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 20, 50, 10);
        this.magySlider.setDecimalPrecision(0);
        this.magySlider.setLabel("");
        this.magzSlider = this.controlP5.addSlider("magzSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 30, 50, 10);
        this.magzSlider.setDecimalPrecision(0);
        this.magzSlider.setLabel("");
        this.debug1Slider = this.controlP5.addSlider("debug1Slider", -32000.0f, 32000.0f, 0.0f, n3 + 20, n7 + 10, 50, 10);
        this.debug1Slider.setDecimalPrecision(0);
        this.debug1Slider.setLabel("");
        this.debug2Slider = this.controlP5.addSlider("debug2Slider", -32000.0f, 32000.0f, 0.0f, n3 + 20, n7 + 20, 50, 10);
        this.debug2Slider.setDecimalPrecision(0);
        this.debug2Slider.setLabel("");
        this.debug3Slider = this.controlP5.addSlider("debug3Slider", -32000.0f, 32000.0f, 0.0f, n3 + 20, n7 + 30, 50, 10);
        this.debug3Slider.setDecimalPrecision(0);
        this.debug3Slider.setLabel("");
        this.debug4Slider = this.controlP5.addSlider("debug4Slider", -32000.0f, 32000.0f, 0.0f, n3 + 20, n7 + 40, 50, 10);
        this.debug4Slider.setDecimalPrecision(0);
        this.debug4Slider.setLabel("");
        this.scaleSlider = this.controlP5.addSlider("SCALE", 0.0f, 10.0f, 1.0f, this.xGraph + 515, this.yGraph, 75, 20);
        this.scaleSlider.setLabel("");
        this.controlP5.addTextlabel("confP", "P", this.xParam + 45, this.yParam + 5);
        this.controlP5.addTextlabel("confI", "I", this.xParam + 90, this.yParam + 5);
        this.controlP5.addTextlabel("confD", "D", this.xParam + 130, this.yParam + 5);
        this.controlP5.addTextlabel("confPower", "POWER", this.xParam + 155, this.yParam + 5);
        this.controlP5.addTextlabel("confInvert", "INVERT", this.xParam + 210, this.yParam + 5);
        this.controlP5.addTextlabel("confPoles", "N.POLES", this.xParam + 260, this.yParam + 5);
        int n8 = 0;
        while (n8 < 3) {
            this.controlP5.addTextlabel("confLabel" + n8, AXIS_NAME[n8], this.xParam + 3, this.yParam + 23 + n8 * 20);
            this.confP[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confP" + n8, 0.0f, this.xParam + 40, this.yParam + 20 + n8 * 20, 30, 14));
            this.confP[n8].setColorBackground(this.gray_);
            this.confP[n8].setMin(0.0f);
            this.confP[n8].setDirection(0);
            this.confP[n8].setDecimalPrecision(0);
            this.confP[n8].setMultiplier(1.0f);
            this.confP[n8].setMax(50.0f);
            this.confI[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confI" + n8, 0.0f, this.xParam + 75, this.yParam + 20 + n8 * 20, 40, 14));
            this.confI[n8].setColorBackground(this.gray_);
            this.confI[n8].setMin(0.0f);
            this.confI[n8].setDirection(0);
            this.confI[n8].setDecimalPrecision(2);
            this.confI[n8].setMultiplier(0.01f);
            this.confI[n8].setMax(0.5f);
            this.confD[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confD" + n8, 0.0f, this.xParam + 120, this.yParam + 20 + n8 * 20, 30, 14));
            this.confD[n8].setColorBackground(this.gray_);
            this.confD[n8].setMin(0.0f);
            this.confD[n8].setDirection(0);
            this.confD[n8].setDecimalPrecision(0);
            this.confD[n8].setMultiplier(1.0f);
            this.confD[n8].setMax(50.0f);
            this.confPower[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confPower" + n8, 0.0f, this.xParam + 160, this.yParam + 20 + n8 * 20, 30, 14));
            this.confPower[n8].setColorBackground(this.gray_);
            this.confPower[n8].setMin(0.0f);
            this.confPower[n8].setDirection(0);
            this.confPower[n8].setDecimalPrecision(0);
            this.confPower[n8].setMultiplier(1.0f);
            this.confPower[n8].setMax(255.0f);
            this.confInv[n8] = this.controlP5.addToggle("confInv" + n8, false, (float)(this.xParam + 230), (float)(this.yParam + 22 + n8 * 20), 12, 12);
            this.confInv[n8].setColorActive(this.color(255));
            this.confInv[n8].setColorBackground(this.color(120));
            this.confInv[n8].setLabelVisible(false);
            this.confPoles[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confPoles" + n8, 0.0f, this.xParam + 260, this.yParam + 20 + n8 * 20, 30, 14));
            this.confPoles[n8].setColorBackground(this.gray_);
            this.confPoles[n8].setMin(0.0f);
            this.confPoles[n8].setDirection(0);
            this.confPoles[n8].setDecimalPrecision(0);
            this.confPoles[n8].setMultiplier(1.0f);
            this.confPoles[n8].setMax(255.0f);
            ++n8;
        }
        this.controlP5.addTextlabel("rangeFrom", "RC min.angle", this.xRange + 40, this.yRange);
        this.controlP5.addTextlabel("rangeTo", "RC max.angle", this.xRange + 130, this.yRange);
        this.controlP5.addTextlabel("RcLPF", "LPF/SPD", this.xRange + 220, this.yRange);
        this.controlP5.addTextlabel("RcInc", "INC.MODE", this.xRange + 285, this.yRange);
        n8 = 0;
        while (n8 < 3) {
            this.controlP5.addTextlabel("rangeLabel" + n8, AXIS_NAME[n8], this.xRange + 3, this.yRange + 23 + n8 * 20);
            this.confRcMinAngle[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confRcMinAngle" + n8, 0.0f, this.xRange + 60, this.yRange + 20 + n8 * 20, 40, 14));
            this.confRcMinAngle[n8].setColorBackground(this.gray_);
            this.confRcMinAngle[n8].setMin(-180.0f);
            this.confRcMinAngle[n8].setDirection(0);
            this.confRcMinAngle[n8].setDecimalPrecision(0);
            this.confRcMinAngle[n8].setMultiplier(1.0f);
            this.confRcMinAngle[n8].setMax(180.0f);
            this.confRcMaxAngle[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confRcMaxAngle" + n8, 0.0f, this.xRange + 140, this.yRange + 20 + n8 * 20, 40, 14));
            this.confRcMaxAngle[n8].setColorBackground(this.gray_);
            this.confRcMaxAngle[n8].setMin(-180.0f);
            this.confRcMaxAngle[n8].setDirection(0);
            this.confRcMaxAngle[n8].setDecimalPrecision(0);
            this.confRcMaxAngle[n8].setMultiplier(1.0f);
            this.confRcMaxAngle[n8].setMax(180.0f);
            this.confRcLPF[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confRcLPF" + n8, 0.0f, this.xRange + 220, this.yRange + 20 + n8 * 20, 30, 14));
            this.confRcLPF[n8].setColorBackground(this.gray_);
            this.confRcLPF[n8].setMin(0.0f);
            this.confRcLPF[n8].setDirection(0);
            this.confRcLPF[n8].setDecimalPrecision(0);
            this.confRcLPF[n8].setMultiplier(1.0f);
            this.confRcLPF[n8].setMax(10.0f);
            this.confRcInc[n8] = this.controlP5.addToggle("confRcInc" + n8, false, (float)(this.xRange + 300), (float)(this.yRange + 20 + n8 * 20), 12, 12);
            this.confRcInc[n8].setColorActive(this.color(255));
            this.confRcInc[n8].setColorBackground(this.color(120));
            this.confRcInc[n8].setLabelVisible(false);
            ++n8;
        }
        this.controlP5.addTextlabel("extGain", "EXTERNAL FC GAIN", this.xExtGain + 40, this.yExtGain);
        n8 = 0;
        while (n8 < 2) {
            this.controlP5.addTextlabel("extGain" + n8, AXIS_NAME[n8], this.xExtGain + 3, this.yExtGain + 23 + n8 * 20);
            this.confExtGain[n8] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confExtGain" + n8, 0.0f, this.xExtGain + 40, this.yExtGain + 20 + n8 * 20, 30, 14));
            this.confExtGain[n8].setColorBackground(this.gray_);
            this.confExtGain[n8].setMin(-128.0f);
            this.confExtGain[n8].setDirection(0);
            this.confExtGain[n8].setDecimalPrecision(0);
            this.confExtGain[n8].setMultiplier(1.0f);
            this.confExtGain[n8].setMax(127.0f);
            ++n8;
        }
        this.controlP5.addTextlabel("gyroLPF", "GYRO LPF:", this.xLPF, this.yLPF);
        this.confGyroLPF = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confGyroLPF", 0.0f, this.xLPF + 80, this.yLPF - 3, 30, 14));
        this.confGyroLPF.setColorBackground(this.gray_);
        this.confGyroLPF.setMin(0.0f);
        this.confGyroLPF.setDirection(0);
        this.confGyroLPF.setDecimalPrecision(0);
        this.confGyroLPF.setMultiplier(1.0f);
        this.confGyroLPF.setMax(5.0f);
        n8 = 145;
        this.controlP5.addTextlabel("debugVars", "DEBUG VARS:", 15, n8);
        n8 += 20;
        int n9 = 0;
        while (n9 < 5) {
            this.controlP5.addTextlabel("labelVar" + n9, "var" + n9 + ":", 20, n8 + 4);
            this.confDebug[n9] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confDebug" + n9, 0.0f, 55, n8, 40, 14));
            this.confDebug[n9].setMin(-32000.0f);
            this.confDebug[n9].setDirection(0);
            this.confDebug[n9].setDecimalPrecision(0);
            this.confDebug[n9].setMultiplier(1.0f);
            this.confDebug[n9].setMax(32000.0f);
            n8 += 20;
            ++n9;
        }
        this.buttonSAVE_DEBUG = this.controlP5.addButton("SAVE_DEBUG", 1.0f, 20, n8 + 5, 70, 16);
        this.buttonSAVE_DEBUG.setLabel("    SAVE");
        this.buttonREAD = this.controlP5.addButton("READ", 1.0f, this.xParam + 5, this.yParam + 260, 60, 16);
        this.buttonREAD.setColorBackground(this.gray_);
        this.buttonWRITE = this.controlP5.addButton("WRITE", 1.0f, this.xParam + 290, this.yParam + 260, 60, 16);
        this.buttonWRITE.setColorBackground(this.gray_);
        this.buttonCALIBRATE_ACC = this.controlP5.addButton("CALIB_ACC", 1.0f, this.xParam + 210, this.yParam + 260, 70, 16);
        this.buttonCALIBRATE_ACC.setColorBackground(this.gray_);
        this.buttonUSE_DEFAULTS = this.controlP5.addButton("USE_DEFAULTS", 1.0f, this.xParam + 75, this.yParam + 260, 100, 16);
        this.buttonUSE_DEFAULTS.setColorBackground(this.gray_);
        this.buttonAUTO_GAIN = this.controlP5.addButton("CALIB_EXT_GAIN", 1.0f, this.xExtGain + 80, this.yExtGain + 20, 80, 35);
        this.buttonAUTO_GAIN.setLabel("     AUTO");
        this.buttonAUTO_GAIN.setColorBackground(this.gray_);
        this.buttonAUTO_POLES = this.controlP5.addButton("CALIB_POLES", 1.0f, this.xParam + 295, this.yParam + 20, 50, 35);
        this.buttonAUTO_POLES.setLabel("  AUTO");
        this.buttonAUTO_POLES.setColorBackground(this.gray_);
        this.controlP5.addTextlabel("rcLabel", "RC INPUT", this.xRC + 5, this.yRC + 5);
        this.rcStickRollSlider = this.controlP5.addSlider("rcRoll", 900.0f, 2100.0f, 1500.0f, this.xRC + 5, this.yRC + 20, 100, 10);
        this.rcStickRollSlider.setDecimalPrecision(0);
        this.rcStickPitchSlider = this.controlP5.addSlider("rcPitch", 900.0f, 2100.0f, 1500.0f, this.xRC + 5, this.yRC + 35, 100, 10);
        this.rcStickPitchSlider.setDecimalPrecision(0);
        this.rcStickYawSlider = this.controlP5.addSlider("rcYaw", 900.0f, 2100.0f, 1500.0f, this.xRC + 5, this.yRC + 50, 100, 10);
        this.rcStickYawSlider.setDecimalPrecision(0);
        this.controlP5.addTextlabel("extLabel", "EXT FC INPUT", this.xRC + 5, this.yRC + 70);
        this.extRollSlider = this.controlP5.addSlider("extRoll", 900.0f, 2100.0f, 1500.0f, this.xRC + 5, this.yRC + 85, 100, 10);
        this.extRollSlider.setDecimalPrecision(0);
        this.extPitchSlider = this.controlP5.addSlider("extPitch", 900.0f, 2100.0f, 1500.0f, this.xRC + 5, this.yRC + 100, 100, 10);
        this.extPitchSlider.setDecimalPrecision(0);
        this.showControls(DEBUG_CONTROLS, false);
        this.showControls(YAW_CONTROLS, false);
    }

    public void draw() {
        this.cycleCnt = (short)(this.cycleCnt + 1);
        this.background(80);
        this.textFont(this.font12);
        this.fill(204.0f, 204.0f, 204.0f);
        this.text("Board ver:", 5.0f, 20.0f);
        this.text(String.valueOf(this.version / 10) + "." + this.version % 10 + (this.subversion > 0 ? " b" + this.subversion : ""), 70.0f, 20.0f);
        this.textFont(this.font15);
        if (this.i2cError > 100 && this.timeToFlash()) {
            this.fill(255.0f, 0.0f, 0.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.text(this.i2cError, this.xGraph + 410, this.yGraph - 10);
        this.fill(255.0f, 255.0f, 255.0f);
        this.textFont(this.font12);
        this.text("I2C error:", this.xGraph + 350, this.yGraph - 10);
        if (this.showDebug) {
            this.textFont(this.font12);
            this.text("Cycle Time:", this.xGraph + 220, this.yGraph - 10);
            this.textFont(this.font15);
            this.text(this.cycleTime, this.xGraph + 290, this.yGraph - 10);
        }
        if (this.init_com == 1) {
            this.processSerial();
            if (this.graphEnable) {
                this.g_serial.write(68);
            }
        }
        this.stroke(255);
        float f = this.angx < -90.0f ? SimpleBGC_GUI_1_3.radians((float)(-180.0f - this.angx)) : (this.angx > 90.0f ? SimpleBGC_GUI_1_3.radians((float)(180.0f - this.angx)) : SimpleBGC_GUI_1_3.radians((float)this.angx));
        float f2 = SimpleBGC_GUI_1_3.radians((float)this.angy);
        SimpleBGC_GUI_1_3.radians((float)this.head);
        float f3 = 30.0f;
        this.pushMatrix();
        this.translate(this.xObj + 60, this.yObj - 170);
        this.rotate(f);
        this.textFont(this.font15);
        this.text("ROLL", -20.0f, 15.0f);
        this.line(-30.0f, 0.0f, 30.0f, 0.0f);
        this.line(0.0f, 0.0f, 0.0f, -10.0f);
        this.popMatrix();
        this.pushMatrix();
        this.translate(this.xObj + 60, this.yObj - 90);
        this.rotate(f2);
        this.textFont(this.font15);
        this.text("PITCH", -30.0f, 15.0f);
        this.line(-30.0f, 0.0f, 30.0f, 0.0f);
        this.line(30.0f, 0.0f, 30.0f - f3 / 3.0f, f3 / 3.0f);
        this.line(30.0f, 0.0f, 30.0f - f3 / 3.0f, -f3 / 3.0f);
        this.popMatrix();
        this.pushMatrix();
        this.translate(this.xObj - 20, this.yObj - 133);
        f3 = 15.0f;
        this.strokeWeight(1.5f);
        this.fill(160);
        this.stroke(160);
        this.ellipse(0.0f, 0.0f, 4.0f * f3 + 7.0f, 4.0f * f3 + 7.0f);
        this.strokeWeight(4.0f);
        this.stroke(200);
        this.line(0.0f, 0.0f, 0.0f, -3.0f * f3);
        this.line(0.0f, -3.0f * f3, -5.0f, -3.0f * f3 + 10.0f);
        this.line(0.0f, -3.0f * f3, 5.0f, -3.0f * f3 + 10.0f);
        this.strokeWeight(1.5f);
        this.fill(0);
        this.stroke(0);
        this.ellipse(0.0f, 0.0f, 2.0f * f3 + 7.0f, 2.0f * f3 + 7.0f);
        this.stroke(255);
        this.rotate(this.head * (float)Math.PI / 180.0f);
        this.line(0.0f, f3, 0.0f, -f3);
        this.line(0.0f, -f3, -5.0f, -f3 + 10.0f);
        this.line(0.0f, -f3, 5.0f, -f3 + 10.0f);
        this.popMatrix();
        this.text("N", this.xObj - 25, this.yObj - 155);
        this.text("S", this.xObj - 25, this.yObj - 100);
        this.text("W", this.xObj - 53, this.yObj - 127);
        this.text("E", this.xObj, this.yObj - 127);
        this.stroke(110);
        this.fill(110);
        this.rect(this.xObj + 60, this.yObj - 120, this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)((this.angx - this.avgRoll.res()) * 10.0f)), (int)-50, (int)50), this.yObj - 110);
        this.rect(this.xObj + 60, this.yObj - 40, this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)((this.angy - this.avgPitch.res()) * 10.0f)), (int)-50, (int)50), this.yObj - 30);
        this.stroke(255.0f, 0.0f, 0.0f);
        int n = this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)(this.peakRoll.getMin() * 10.0f)), (int)-50, (int)0);
        this.line(n, this.yObj - 120, n, this.yObj - 110);
        n = this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)(this.peakRoll.getMax() * 10.0f)), (int)0, (int)50);
        this.line(n, this.yObj - 120, n, this.yObj - 110);
        n = this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)(this.peakPitch.getMin() * 10.0f)), (int)-50, (int)0);
        this.line(n, this.yObj - 40, n, this.yObj - 30);
        n = this.xObj + 60 + SimpleBGC_GUI_1_3.constrain((int)((int)(this.peakPitch.getMax() * 10.0f)), (int)0, (int)50);
        this.line(n, this.yObj - 40, n, this.yObj - 30);
        this.textFont(this.font12);
        this.fill(255.0f, 0.0f, 0.0f);
        this.text(String.format("%.1f", Float.valueOf(this.peakRoll.getMax() - this.peakRoll.getMin())), this.xObj + 80, this.yObj - 130);
        this.text(String.format("%.1f", Float.valueOf(this.peakPitch.getMax() - this.peakPitch.getMin())), this.xObj + 80, this.yObj - 50);
        this.textFont(this.font12);
        this.fill(160);
        this.text(String.format("%.1f", Float.valueOf(this.angx)), this.xObj + 50, this.yObj - 130);
        this.text(String.format("%.1f", Float.valueOf(this.angy)), this.xObj + 50, this.yObj - 50);
        this.text(String.format("%.1f", Float.valueOf(this.head)), this.xObj - 30, this.yObj - 80);
        this.strokeWeight(1.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.g_graph.drawGraphBox();
        this.strokeWeight(1.5f);
        this.stroke(255.0f, 0.0f, 0.0f);
        if (this.axGraph) {
            this.g_graph.drawLine(this.accROLL, -1000.0f, 1000.0f);
        }
        this.stroke(0.0f, 255.0f, 0.0f);
        if (this.ayGraph) {
            this.g_graph.drawLine(this.accPITCH, -1000.0f, 1000.0f);
        }
        this.stroke(0.0f, 0.0f, 255.0f);
        if (this.azGraph) {
            if (this.scaleSlider.value() < 2.0f) {
                this.g_graph.drawLine(this.accYAW, -1000.0f, 1000.0f);
            } else {
                this.g_graph.drawLine(this.accYAW, 200.0f * this.scaleSlider.value() - 1000.0f, 200.0f * this.scaleSlider.value() + 500.0f);
            }
        }
        this.stroke(200.0f, 200.0f, 0.0f);
        if (this.gxGraph) {
            this.g_graph.drawLine(this.gyroROLL, -500.0f, 500.0f);
        }
        this.stroke(0.0f, 255.0f, 255.0f);
        if (this.gyGraph) {
            this.g_graph.drawLine(this.gyroPITCH, -500.0f, 500.0f);
        }
        this.stroke(255.0f, 0.0f, 255.0f);
        if (this.gzGraph) {
            this.g_graph.drawLine(this.gyroYAW, -500.0f, 500.0f);
        }
        this.stroke(50.0f, 100.0f, 150.0f);
        if (this.magxGraph) {
            this.g_graph.drawLine(this.magxData, -500.0f, 500.0f);
        }
        this.stroke(100.0f, 50.0f, 150.0f);
        if (this.magyGraph) {
            this.g_graph.drawLine(this.magyData, -500.0f, 500.0f);
        }
        this.stroke(150.0f, 100.0f, 50.0f);
        if (this.magzGraph) {
            this.g_graph.drawLine(this.magzData, -500.0f, 500.0f);
        }
        this.stroke(50.0f, 100.0f, 150.0f);
        if (this.debug1Graph) {
            this.g_graph.drawLine(this.debug1Data, -5000.0f, 5000.0f);
        }
        this.stroke(100.0f, 50.0f, 150.0f);
        if (this.debug2Graph) {
            this.g_graph.drawLine(this.debug2Data, -5000.0f, 5000.0f);
        }
        this.stroke(150.0f, 100.0f, 50.0f);
        if (this.debug3Graph) {
            this.g_graph.drawLine(this.debug3Data, -5000.0f, 5000.0f);
        }
        this.stroke(150.0f, 150.0f, 0.0f);
        if (this.debug4Graph) {
            this.g_graph.drawLine(this.debug4Data, -5000.0f, 5000.0f);
        }
        this.fill(0.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.rectMode(1);
        this.rect(this.xParam, this.yParam, this.xParam + 355, this.yParam + 280);
        this.rect(this.xRC, this.yRC, this.xRC + 170, this.yRC + 120);
        this.stroke(50);
        this.rect(this.xParam + 220, this.yParam + 15, this.xParam + 350, this.yParam + 60);
        if (this.error != null) {
            this.textFont(this.font15);
            this.fill(-65536);
            this.text(this.error.text, 150.0f, 400.0f, 450.0f, 430.0f);
            this.textFont(this.font12);
            this.fill(-16777216);
            this.text(this.error.hint, 150.0f, 440.0f, 450.0f, 500.0f);
        }
    }

    public void ACC_ROLL(boolean bl) {
        this.axGraph = bl;
    }

    public void ACC_PITCH(boolean bl) {
        this.ayGraph = bl;
    }

    public void ACC_Z(boolean bl) {
        this.azGraph = bl;
    }

    public void GYRO_ROLL(boolean bl) {
        this.gxGraph = bl;
    }

    public void GYRO_PITCH(boolean bl) {
        this.gyGraph = bl;
    }

    public void GYRO_YAW(boolean bl) {
        this.gzGraph = bl;
    }

    public void MAGX(boolean bl) {
        this.magxGraph = bl;
    }

    public void MAGY(boolean bl) {
        this.magyGraph = bl;
    }

    public void MAGZ(boolean bl) {
        this.magzGraph = bl;
    }

    public void DEBUG1(boolean bl) {
        this.debug1Graph = bl;
    }

    public void DEBUG2(boolean bl) {
        this.debug2Graph = bl;
    }

    public void DEBUG3(boolean bl) {
        this.debug3Graph = bl;
    }

    public void DEBUG4(boolean bl) {
        this.debug4Graph = bl;
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup() && controlEvent.name() == "portComList") {
            this.InitSerial(controlEvent.group().value());
        }
    }

    public void READ() {
        if (!this.readEnable) {
            return;
        }
        this.g_serial.write(82);
        this.g_serial.write(114);
    }

    public void SerialWrite(float f) {
        this.g_serial.write((int)PApplet.parseChar((int)SimpleBGC_GUI_1_3.round((float)f)));
    }

    public void SerialWrite16(float f) {
        int n = SimpleBGC_GUI_1_3.round((float)f);
        this.g_serial.write((int)((byte)(n & 0xFF)));
        this.g_serial.write((int)((byte)(n >> 8 & 0xFF)));
    }

    public void WRITE() {
        if (!this.writeEnable) {
            return;
        }
        this.g_serial.write(87);
        int n = 0;
        while (n < 3) {
            this.SerialWrite(this.confP[n].value());
            this.SerialWrite(this.confI[n].value() * 100.0f);
            this.SerialWrite(this.confD[n].value());
            this.SerialWrite(this.confPower[n].value());
            this.SerialWrite(this.confInv[n].getState() ? 1 : 0);
            this.SerialWrite(this.confPoles[n].value());
            ++n;
        }
        n = 0;
        while (n < 3) {
            this.SerialWrite16(this.confRcMinAngle[n].value());
            this.SerialWrite16(this.confRcMaxAngle[n].value());
            this.SerialWrite(this.confRcLPF[n].value());
            this.SerialWrite(this.confRcInc[n].getState() ? 1 : 0);
            ++n;
        }
        n = 0;
        while (n < 2) {
            this.SerialWrite(this.confExtGain[n].value());
            ++n;
        }
        this.SerialWrite(this.confGyroLPF.value());
    }

    public void SAVE_DEBUG() {
        if (!this.writeEnable) {
            return;
        }
        this.g_serial.write(119);
        int n = 0;
        while (n < 5) {
            this.SerialWrite16(this.confDebug[n].value());
            ++n;
        }
    }

    public void CALIB_ACC() {
        if (!this.calibrateEnable) {
            return;
        }
        this.g_serial.write(65);
    }

    public void USE_DEFAULTS() {
        if (!this.calibrateEnable) {
            return;
        }
        this.g_serial.write(70);
    }

    public void CALIB_EXT_GAIN() {
        if (!this.calibrateEnable) {
            return;
        }
        this.g_serial.write(71);
    }

    public void CALIB_POLES() {
        if (!this.calibrateEnable) {
            return;
        }
        this.g_serial.write(80);
    }

    public void InitSerial(float f) {
        if (f < (float)this.commListMax) {
            String string = Serial.list()[PApplet.parseInt((float)f)];
            this.txtlblWhichcom.setValue("COM = " + this.shortifyPortName(string, 8));
            this.g_serial = new Serial((PApplet)this, string, 115200);
            this.init_com = 1;
            this.commListbox.setColorBackground(this.green_);
            this.buttonREAD.setColorBackground(this.green_);
            this.buttonCALIBRATE_ACC.setColorBackground(this.green_);
            this.buttonUSE_DEFAULTS.setColorBackground(this.green_);
            this.buttonAUTO_GAIN.setColorBackground(this.blue_);
            this.buttonAUTO_POLES.setColorBackground(this.blue_);
            this.readEnable = true;
            this.calibrateEnable = true;
            this.graphEnable = true;
            this.g_serial.buffer(256);
            this.READ();
        } else {
            this.txtlblWhichcom.setValue("Comm Closed");
            this.init_com = 0;
            this.commListbox.setColorBackground(this.gray_);
            this.graphEnable = false;
            this.readEnable = false;
            this.init_com = 0;
            this.g_serial.stop();
        }
    }

    public int read16() {
        return (this.inBuf[this.p++] & 0xFF) + (this.inBuf[this.p++] << 8);
    }

    public int read8() {
        return this.inBuf[this.p++] & 0xFF;
    }

    public boolean serialReadBuf(int n) {
        while (this.g_serial.available() > 0 && this.serialReaded < n) {
            this.inBuf[this.serialReaded++] = (byte)this.g_serial.read();
        }
        return this.serialReaded >= n;
    }

    public void processSerial() {
        while (this.g_serial.available() > 0) {
            int n;
            int n2;
            if (this.serialState == 0) {
                this.serialState = this.g_serial.read();
                this.serialReaded = 0;
            }
            if (this.serialState == 82) {
                if (!this.serialReadBuf(44)) continue;
                if (this.inBuf[43] == 82) {
                    this.error = null;
                    this.p = 0;
                    this.version = this.read8();
                    this.subversion = this.read8();
                    n2 = this.read8();
                    NUM_AXIS = this.read8();
                    NUM_AXIS = SimpleBGC_GUI_1_3.constrain((int)NUM_AXIS, (int)2, (int)3);
                    n = 0;
                    while (n < 3) {
                        this.confP[n].setValue((float)this.read8());
                        this.confI[n].setValue((float)this.read8() / 100.0f);
                        this.confD[n].setValue((float)this.read8());
                        this.confPower[n].setValue((float)this.read8());
                        this.confInv[n].setState(this.read8() > 0);
                        this.confPoles[n].setValue((float)this.read8());
                        ++n;
                    }
                    n = 0;
                    while (n < 3) {
                        this.confRcMinAngle[n].setValue((float)this.read16());
                        this.confRcMaxAngle[n].setValue((float)this.read16());
                        this.confRcLPF[n].setValue((float)this.read8());
                        this.confRcInc[n].setState(this.read8() > 0);
                        ++n;
                    }
                    n = 0;
                    while (n < 2) {
                        this.confExtGain[n].setValue((float)((byte)this.read8()));
                        ++n;
                    }
                    this.confGyroLPF.setValue((float)this.read8());
                    this.buttonWRITE.setColorBackground(this.green_);
                    this.writeEnable = true;
                    this.showDebug = n2 > 0;
                    this.showControls(DEBUG_CONTROLS, this.showDebug);
                    this.showControls(YAW_CONTROLS, NUM_AXIS >= 3);
                } else {
                    this.error = this.getErrorInfo(128);
                }
                this.serialState = 0;
                continue;
            }
            if (this.serialState == 68) {
                if (!this.serialReadBuf(48)) continue;
                if (this.inBuf[47] == 68) {
                    this.p = 0;
                    n2 = this.read16();
                    n = this.read16();
                    int n3 = this.read16();
                    int n4 = this.read16() / 10;
                    int n5 = this.read16() / 10;
                    int n6 = this.read16() / 10;
                    int n7 = this.read16();
                    int n8 = this.read16();
                    int n9 = this.read16();
                    int n10 = this.read16();
                    int n11 = this.read16();
                    int n12 = this.read16();
                    int n13 = this.read16();
                    int n14 = this.read16();
                    int n15 = this.read16();
                    int n16 = this.read16();
                    int n17 = this.read16();
                    int n18 = this.read16();
                    this.angx = (float)this.read16() / 10.0f;
                    this.angy = (float)this.read16() / 10.0f;
                    this.head = (float)this.read16() / 10.0f;
                    this.cycleTime = this.read16();
                    this.i2cError = this.read16();
                    this.error = this.getErrorInfo(this.read8());
                    this.avgRoll.addData(this.angx);
                    this.avgPitch.addData(this.angy);
                    this.peakRoll.addData(this.angx - this.avgRoll.res());
                    this.peakPitch.addData(this.angy - this.avgPitch.res());
                    this.accROLL.addVal(n2);
                    this.accPITCH.addVal(n);
                    this.accYAW.addVal(n3);
                    this.gyroROLL.addVal(n4);
                    this.gyroPITCH.addVal(n5);
                    this.gyroYAW.addVal(n6);
                    this.magxData.addVal(n7);
                    this.magyData.addVal(n8);
                    this.magzData.addVal(n9);
                    this.debug1Data.addVal(n10);
                    this.debug2Data.addVal(n11);
                    this.debug3Data.addVal(n12);
                    this.debug4Data.addVal(n13);
                    this.axSlider.setValue((float)n2);
                    this.aySlider.setValue((float)n);
                    this.azSlider.setValue((float)n3);
                    this.gxSlider.setValue((float)n4);
                    this.gySlider.setValue((float)n5);
                    this.gzSlider.setValue((float)n6);
                    this.magxSlider.setValue((float)n7);
                    this.magySlider.setValue((float)n8);
                    this.magzSlider.setValue((float)n9);
                    this.debug1Slider.setValue((float)n10);
                    this.debug2Slider.setValue((float)n11);
                    this.debug3Slider.setValue((float)n12);
                    this.debug4Slider.setValue((float)n13);
                    this.rcStickRollSlider.setValue((float)n14);
                    this.rcStickPitchSlider.setValue((float)n15);
                    this.rcStickYawSlider.setValue((float)n16);
                    this.extRollSlider.setValue((float)n17);
                    this.extPitchSlider.setValue((float)n18);
                    if (this.error != null) {
                        this.buttonCALIBRATE_ACC.setColorBackground(this.error.code == 2 && this.timeToFlash() ? this.red_ : this.green_);
                        this.confPower[0].setColorBackground(this.error.code == 4 && this.confPower[0].value() == 0.0f && this.timeToFlash() ? this.red_ : this.gray_);
                        this.confPower[1].setColorBackground(this.error.code == 4 && this.confPower[1].value() == 0.0f && this.timeToFlash() ? this.red_ : this.gray_);
                        this.confPower[2].setColorBackground(this.error.code == 4 && this.confPower[2].value() == 0.0f && this.timeToFlash() ? this.red_ : this.gray_);
                        this.buttonAUTO_POLES.setColorBackground(this.error.code == 8 && this.timeToFlash() ? this.red_ : this.blue_);
                    }
                } else {
                    this.error = this.getErrorInfo(128);
                }
                this.serialState = 0;
                continue;
            }
            if (this.serialState == 114) {
                if (this.serialReadBuf(11)) {
                    if (this.inBuf[10] == 114) {
                        this.p = 0;
                        n2 = 0;
                        while (n2 < 5) {
                            this.confDebug[n2].setValue((float)this.read16());
                            ++n2;
                        }
                    } else {
                        this.error = this.getErrorInfo(128);
                    }
                }
                this.serialState = 0;
                continue;
            }
            if (this.serialState == 80 || this.serialState == 65) {
                this.g_serial.read();
                this.serialState = 0;
                continue;
            }
            this.serialState = 0;
            this.error = this.getErrorInfo(128);
            this.g_serial.readBytesUntil(68, this.inBuf);
        }
    }

    public boolean timeToFlash() {
        return (this.cycleCnt & 8) != 0;
    }

    public void showControls(String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            Controller controller = this.controlP5.controller(stringArray[n]);
            if (controller != null) {
                if (bl) {
                    controller.show();
                } else {
                    controller.hide();
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "SimpleBGC_GUI_1_3"});
    }

    class AvgFilter {
        private float res = 0.0f;
        private float factor;
        private float inv_factor;

        AvgFilter(float f) {
            this.factor = f;
            this.inv_factor = 1.0f / (f + 1.0f);
        }

        public void addData(float f) {
            this.res = (this.res * this.factor + f) * this.inv_factor;
        }

        public float res() {
            return this.res;
        }
    }

    class ErrorInfo {
        int code;
        public final String text;
        public final String hint;

        ErrorInfo(int n, String string, String string2) {
            this.code = n;
            this.text = string;
            this.hint = string2;
        }
    }

    class PeakMeter {
        private float[] buf;
        private int pos = 0;
        private float min = 0.0f;
        private float max = 0.0f;

        PeakMeter(int n) {
            this.buf = new float[n];
        }

        public void addData(float f) {
            this.buf[this.pos] = f;
            ++this.pos;
            this.pos %= this.buf.length;
            this.min = this.buf[this.pos];
            this.max = this.buf[this.pos];
            int n = 0;
            while (n < this.buf.length) {
                int n2 = (n + this.pos) % this.buf.length;
                if (this.buf[n2] > this.max) {
                    this.max = this.buf[n2];
                }
                if (this.buf[n2] < this.min) {
                    this.min = this.buf[n2];
                }
                ++n;
            }
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }
    }

    class cDataArray {
        float[] m_data;
        int m_maxSize;
        int m_startIndex = 0;
        int m_endIndex = 0;
        int m_curSize;

        cDataArray(int n) {
            this.m_maxSize = n;
            this.m_data = new float[n];
        }

        public void addVal(float f) {
            this.m_data[this.m_endIndex] = f;
            this.m_endIndex = (this.m_endIndex + 1) % this.m_maxSize;
            if (this.m_curSize == this.m_maxSize) {
                this.m_startIndex = (this.m_startIndex + 1) % this.m_maxSize;
            } else {
                ++this.m_curSize;
            }
        }

        public float getVal(int n) {
            return this.m_data[(this.m_startIndex + n) % this.m_maxSize];
        }

        public int getCurSize() {
            return this.m_curSize;
        }

        public int getMaxSize() {
            return this.m_maxSize;
        }

        public float getMaxVal() {
            float f = 0.0f;
            int n = 0;
            while (n < this.m_curSize - 1) {
                if (this.m_data[n] > f || n == 0) {
                    f = this.m_data[n];
                }
                ++n;
            }
            return f;
        }

        public float getMinVal() {
            float f = 0.0f;
            int n = 0;
            while (n < this.m_curSize - 1) {
                if (this.m_data[n] < f || n == 0) {
                    f = this.m_data[n];
                }
                ++n;
            }
            return f;
        }

        public float getRange() {
            return this.getMaxVal() - this.getMinVal();
        }
    }

    class cGraph {
        float m_gWidth;
        float m_gHeight;
        float m_gLeft;
        float m_gBottom;
        float m_gRight;
        float m_gTop;

        cGraph(float f, float f2, float f3, float f4) {
            this.m_gWidth = f3;
            this.m_gHeight = f4;
            this.m_gLeft = f;
            this.m_gBottom = f2;
            this.m_gRight = f + f3;
            this.m_gTop = f2 + f4;
        }

        public void drawGraphBox() {
            SimpleBGC_GUI_1_3.this.stroke(0.0f, 0.0f, 0.0f);
            SimpleBGC_GUI_1_3.this.rectMode(1);
            SimpleBGC_GUI_1_3.this.rect(this.m_gLeft, this.m_gBottom, this.m_gRight, this.m_gTop);
        }

        public void drawLine(cDataArray cDataArray2, float f, float f2) {
            float f3 = this.m_gWidth / (float)cDataArray2.getMaxSize();
            float f4 = this.m_gHeight / (f2 - f);
            int n = 0;
            while (n < cDataArray2.getCurSize() - 1) {
                float f5 = (float)n * f3 + this.m_gLeft;
                float f6 = this.m_gTop - ((cDataArray2.getVal(n) - (f2 + f) / 2.0f) * SimpleBGC_GUI_1_3.this.scaleSlider.value() + (f2 - f) / 2.0f) * f4;
                float f7 = (float)(n + 1) * f3 + this.m_gLeft;
                float f8 = this.m_gTop - ((cDataArray2.getVal(n + 1) - (f2 + f) / 2.0f) * SimpleBGC_GUI_1_3.this.scaleSlider.value() + (f2 - f) / 2.0f) * f4;
                SimpleBGC_GUI_1_3.this.line(f5, f6, f7, f8);
                ++n;
            }
        }
    }
}

